<?php
/**
 * Elementor Widget
 * @package panthar
 * @since 1.0.0
 */

namespace Elementor;

class Panthar_Team_List_two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'panthar-team-list-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Team List Two', 'panthar-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-person';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['panthar_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'slider_settings_section',
            [
                'label' => esc_html__('Team Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('team_grid', [
            'label' => esc_html__('Team Grid', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'col-lg-3' => esc_html__('col-lg-2', 'panthar-core'),
                'col-lg-3' => esc_html__('col-lg-3', 'panthar-core'),
                'col-lg-4' => esc_html__('col-lg-4', 'panthar-core'),
                'col-lg-6' => esc_html__('col-lg-6', 'panthar-core'),
            ),
            'default' => 'col-lg-4',
            'description' => esc_html__('Select Case Study Grid', 'panthar-core')
        ]);
        $this->add_control(
            'pagination',
            [
                'label' => esc_html__('Pagination', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes to show pagination.', 'panthar-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'offset',
            [
                'label' => esc_html__('Post Offset', 'panthar-core'),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $this->add_control(
            'pagination_alignment',
            [
                'label' => esc_html__('Pagination Alignment', 'panthar-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'left' => esc_html__('Left Align', 'panthar-core'),
                    'center' => esc_html__('Center Align', 'panthar-core'),
                    'right' => esc_html__('Right Align', 'panthar-core'),
                ),
                'description' => esc_html__('you can set pagination alignment.', 'panthar-core'),
                'default' => 'left',
                'condition' => array('pagination' => 'yes')
            ]
        );
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'panthar-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many course you want in masonry , enter -1 for unlimited course.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'panthar-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => Panthar()->get_terms_names('case-study-cat', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'panthar-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'panthar-core'),
                'DESC' => esc_html__('Descending', 'panthar-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'panthar-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'panthar-core'),
                'title' => esc_html__('Title', 'panthar-core'),
                'date' => esc_html__('Date', 'panthar-core'),
                'rand' => esc_html__('Random', 'panthar-core'),
                'comment_count' => esc_html__('Most Comments', 'panthar-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'panthar-core')
        ]);
        $this->end_controls_section();

        $this->start_controls_section(
            'case_study_member_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'normal_background',
                'label' => esc_html__('Background', 'panthar-core'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .case-study-single-item-02 .content',
            ]
        );
        $this->add_control('name_color', [
            'label' => esc_html__('Name Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .case-study-single-item-02 .content .title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('designation_color', [
            'label' => esc_html__('Designation Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-team-inner .content p" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('case_study_social_icon_styling_divider', [
            'type' => Controls_Manager::DIVIDER
        ]);

        $this->start_controls_tabs(
            'case_study_social_icon_style_tabs'
        );

        $this->start_controls_tab(
            'case_study_social_icon_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'panthar-core'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'social_bg_icon_normal_background',
                'label' => esc_html__('Background', 'panthar-core'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .case-study-single-item-02 .social-icon li',
            ]
        );
        $this->add_control('social_icon_color', [
            'label' => esc_html__('Icon Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .case-study-single-item-02 .social-icon li" => "color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'case_study_social_icon_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'panthar-core'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'social_icon_hover_background',
                'label' => esc_html__('Background', 'panthar-core'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .case-study-single-item-02 .social-icon li:hover',
            ]
        );
        $this->add_control('social_hover_icon_color', [
            'label' => esc_html__('Icon Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .case-study-single-item-02 .social-icon li:hover" => "color: {{VALUE}}"
            ]
        ]);

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control('case_study_typography_divider', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'name_typography',
            'label' => esc_html__('Name Typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .single-team-inner .content .title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'designation_typography',
            'label' => esc_html__('Designation Typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .single-team-inner .content p"
        ]);
        $this->end_controls_section();

    }


    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];
        $offset = $settings['offset'];
        //other settings
        $pagination = $settings['pagination'] ? false : true;
        $pagination_alignment = $settings['pagination_alignment'];
        //setup query
        $args = array(
            'post_type' => 'team',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'offset'  => $offset,
            'post_status' => 'publish'
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'team-cat',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>
        <div class="row justify-content-center">
            <?php
            while ($post_data->have_posts()) : $post_data->the_post();
                $post_id = get_the_ID();
                $img_id = get_post_thumbnail_id($post_id) ? get_post_thumbnail_id($post_id) : false;
                $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'panthar_classic_team_two', false) : '';
                $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

                $team_single_meta_data = get_post_meta(get_the_ID(), 'panthar_team_options', true);
                $social_icons = isset($team_single_meta_data['social-icons']) && !empty($team_single_meta_data['social-icons']) ? $team_single_meta_data['social-icons'] : '';

                ?>
                <div class="<?php echo esc_attr($settings['team_grid']); ?> col-md-6">
                    <div class="single-team-inner single-team-inner-two text-center">
                        <div class="thumb">
                            <img src="<?php echo esc_url($img_url)?>" alt="<?php echo $img_alt?>">
                            <span class="animate-1"></span>
                            <span class="animate-2"></span>
                            <span class="animate-3"></span>
                            <span class="animate-4"></span>
                        </div>
                        <div class="details">
                            <div class="team-social-list">
                                <ul>
                                    <?php
                                    if (!empty($social_icons)) {
                                        foreach ($social_icons as $s_info) {
                                            $s_infos =strtolower($s_info['title']);
                                            printf('<li><a href="%2$s"><i class="fab fa-'. $s_infos .'"></i></a></li>', $s_info['title'], $s_info['url']);


                                        }
                                    }
                                    ?>
                                </ul>
                            </div>
                            <div class="content">
                                <a href="<?php the_permalink() ?>">
                                    <h4 class="title"><?php echo esc_html(get_the_title($post_id)) ?></h4>
                                </a>
                                <p><?php echo $team_single_meta_data['designation'] ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
            
            <div class="col-lg-12">
                <div class="blog-pagination text-<?php echo esc_attr($pagination_alignment) ?> margin-top-20">
                    <?php
                    if (!$pagination) {
                        Panthar()->post_pagination($post_data);
                    }
                    ?>
                </div>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Panthar_Team_List_two_Widget());