<?php
/**
 * Elementor Widget
 * @package Panthar
 * @since 1.0.0
 */

namespace Elementor;
class Panthar_Animate_Image_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'panthar-animate-image-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Animate Image', 'panthar-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-image';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['panthar_widgets'];
    }

    public function get_keywords()
    {
        return ['Animate Image', 'Sponsor', 'Clint', "ThemeIM", 'Panthar'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'animate_hide',
            [
                'label' => __('Animate Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'panthar-core'),
                'label_off' => __('Hide', 'panthar-core'),
                'return_value' => 'yes',
            ]
        );
        //image field start
        $this->add_control(
            'animate_image', [
                'label' => esc_html__('Animate Image', 'panthar-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'show_label' => false,
                'description' => esc_html__('Upload Animate image', 'panthar-core'),
            ]
        );
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        
        //hero image variable
        $animate_image = $this->get_settings('animate_image');
        if (empty($animate_image_url)){
            $animate_image_url = $animate_image['url']; 
        } ?>

        <div class="animate-image-inner animate-image-inner-overlay <?php echo $settings['animate_hide']; ?>">
            <div class="thumb">
                <span class="animate-1"></span>
                <span class="animate-2"></span>
                <span class="animate-3"></span>
                <span class="animate-4"></span>
                <img src="<?php echo esc_url($animate_image_url) ?>" alt="<?php echo esc_attr('thumb', 'panthar-core') ?>">
            </div>
        </div>

        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Panthar_Animate_Image_Widget());