<?php
/**
 * Elementor Widget
 * @package Panthar
 * @since 1.0.0
 */

namespace Elementor;
class Panthar_Blog_Grid_LIst_Two_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'panthar-blog-grid-list-two-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Blog Grid List Two', 'panthar-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['panthar_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('General Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'blog_style',
            [
                'label'   => esc_html__( 'Blog Style', 'panthar-core' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-details-bottom',
                'options' => [
                    'style-details-bottom' => esc_html__( 'Details Bottom', 'panthar-core' ),
                    'style-details-top' => esc_html__( 'Details Top', 'panthar-core' ),
                ],
            ]
        );
        
        $this->add_control('blog_grid', [
            'label' => esc_html__('Blog Grid', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'col-lg-3' => esc_html__('col-lg-2', 'panthar-core'),
                'col-lg-3' => esc_html__('col-lg-3', 'panthar-core'),
                'col-lg-4' => esc_html__('col-lg-4', 'panthar-core'),
                'col-lg-6' => esc_html__('col-lg-6', 'panthar-core'),
            ),
            'default' => 'col-lg-4',
            'description' => esc_html__('Select Case Study Grid', 'panthar-core')
        ]);
        $this->add_control(
            'read_more',
            [
                'label' => esc_html__('Read More Show/Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'panthar-core'),
                'default' => 'yes',
            ]
        );
        $this->add_control('read-btn', [
            'label' => esc_html__('Read More', 'panthar-core'),
            'type' => Controls_Manager::TEXT,
            'description' => esc_html__('enter read button text', 'panthar-core'),
            'default' => esc_html__('Read More', 'panthar-core'),
            'condition' => ['read_more' => 'yes'],
        ]);
        $this->add_control('total', [
            'label' => esc_html__('Total Posts', 'panthar-core'),
            'type' => Controls_Manager::TEXT,
            'default' => '-1',
            'description' => esc_html__('enter how many post you want in masonry , enter -1 for unlimited post.')
        ]);
        $this->add_control('category', [
            'label' => esc_html__('Category', 'panthar-core'),
            'type' => Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => panthar_core()->get_terms_names('category', 'id'),
            'description' => esc_html__('select category as you want, leave it blank for all category', 'panthar-core'),
        ]);
        $this->add_control('order', [
            'label' => esc_html__('Order', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ASC' => esc_html__('Ascending', 'panthar-core'),
                'DESC' => esc_html__('Descending', 'panthar-core'),
            ),
            'default' => 'ASC',
            'description' => esc_html__('select order', 'panthar-core')
        ]);
        $this->add_control('orderby', [
            'label' => esc_html__('OrderBy', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                'ID' => esc_html__('ID', 'panthar-core'),
                'title' => esc_html__('Title', 'panthar-core'),
                'date' => esc_html__('Date', 'panthar-core'),
                'rand' => esc_html__('Random', 'panthar-core'),
                'comment_count' => esc_html__('Most Comments', 'panthar-core'),
            ),
            'default' => 'ID',
            'description' => esc_html__('select order', 'panthar-core')
        ]);
        $this->add_control('excerpt_length', [
            'label' => esc_html__('Excerpt Length', 'panthar-core'),
            'type' => Controls_Manager::SELECT,
            'options' => array(
                25 => esc_html__('Short', 'panthar-core'),
                55 => esc_html__('Regular', 'panthar-core'),
                100 => esc_html__('Long', 'panthar-core'),
            ),
            'default' => 25,
            'description' => esc_html__('select excerpt length', 'panthar-core')
        ]);
        $this->add_control(
            'thumb_date',
            [
                'label' => esc_html__('Thumb Date Show/Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'panthar-core'),
            ]
        );
        $this->add_control(
            'details_date',
            [
                'label' => esc_html__('Details Date Show/Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'panthar-core'),
            ]
        );
        $this->add_control(
            'bottom_border',
            [
                'label' => esc_html__('Bottom Border Show/Hide', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('show/hide description', 'panthar-core'),
            ]
        );
        $this->add_control(
            'pagination',
            [
                'label' => esc_html__('Pagination', 'panthar-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('you can set yes to show pagination.', 'panthar-core'),
                'default' => 'yes'
            ]
        );
        $this->add_control(
            'pagination_alignment',
            [
                'label' => esc_html__('Pagination Alignment', 'panthar-core'),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'left' => esc_html__('Left Align', 'panthar-core'),
                    'center' => esc_html__('Center Align', 'panthar-core'),
                    'right' => esc_html__('Right Align', 'panthar-core'),
                ),
                'description' => esc_html__('you can set pagination alignment.', 'panthar-core'),
                'default' => 'left',
                'condition' => array('pagination' => 'yes')
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'title_styling_settings_section',
            [
                'label' => esc_html__('Styling Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'title_style_tabs'
        );

        $this->start_controls_tab(
            'title_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'panthar-core'),
            ]
        );
        $this->add_control(
            'image_radius',
            [
                'label' => esc_html__('Image Radius', 'panthar-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .single-blog-item-inner .thumb' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control('normal_post_title_color', [
            'label' => esc_html__('Title Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-blog-item-inner .details .title:hover a" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_post_paragraph_color', [
            'label' => esc_html__('Category Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .news-single-items .content .post-categories li" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_background_color', [
            'label' => esc_html__('Background Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .news-single-items .content" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_post_border_color', [
            'label' => esc_html__('Border Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .news-single-items .content" => "border-color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'panthar-core'),
            ]
        );

        $this->add_control('hover_post_title_color', [
            'label' => esc_html__('Title Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .single-blog-item-inner .details .title:hover" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_hover_background_color', [
            'label' => esc_html__('Background Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .news-single-items:hover .content" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('normal_post_hover_border_color', [
            'label' => esc_html__('Border Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .news-single-items:hover .content" => "border-color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'typography_settings_section',
            [
                'label' => esc_html__('Typography Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Title Typography', 'panthar-core'),
            'name' => 'post_meta_typography',
            'description' => esc_html__('select title typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .single-blog-item-inner.single-blog-item-inner .details .title a"
        ]);

        $this->add_group_control(Group_Control_Typography::get_type(), [
            'label' => esc_html__('Category Typography', 'panthar-core'),
            'name' => 'category_typography',
            'description' => esc_html__('select category typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .single-blog-item-inner.single-blog-item-inner .details .post-categories a",
            'selector' => "{{WRAPPER}} .single-blog-item-inner.single-blog-item-inner .details .author-meta li",
        ]);
        $this->end_controls_section();

    }

    /**
     * Render Elementor widget output on the frontend.
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $rand_numb = rand(333, 999999999);
        //query settings
        $total_posts = $settings['total'];
        $category = $settings['category'];
        $order = $settings['order'];
        $orderby = $settings['orderby'];

        //other settings
        $pagination = $settings['pagination'] ? false : true;
        $pagination_alignment = $settings['pagination_alignment'];

        //setup query
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => $total_posts,
            'order' => $order,
            'orderby' => $orderby,
            'post_status' => 'publish',
            'ignore_sticky_posts' => 1,
        );

        if (!empty($category)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'category',
                    'field' => 'term_id',
                    'terms' => $category
                )
            );
        }
        $post_data = new \WP_Query($args);
        ?>
        <div class="blog-list-item-wrap">
            <div class="row">
                <?php while ($post_data->have_posts()):$post_data->the_post(); 

                    //border condition here
                    $border_style_bottom = ' border-style-bottom';
                    if($settings['bottom_border'] == 'yes'){
                        $border_style_bottom = '';
                    }
                    //image condition here
                    $img_id = get_post_thumbnail_id(get_the_ID()) ? get_post_thumbnail_id(get_the_ID()) : false;
                    $img_url_val = $img_id ? wp_get_attachment_image_src($img_id, 'panthar_grid_blog_2', false) : '';
                    $img_url = is_array($img_url_val) && !empty($img_url_val) ? $img_url_val[0] : '';
                    $img_alt = get_post_meta($img_id, '_wp_attachment_image_alt', true);

                    $comments_count = get_comments_number(get_the_ID());
                    $comment_text = ($comments_count > 1) ? 'Comments (' . $comments_count . ')' : 'Comment (' . $comments_count . ')';
                    ?>
                    

                    <?php 
                        if($settings['blog_style'] == 'style-details-top') { ?>
                            <div class="col-lg-4 col-md-6">
                                <div class="single-blog-item-inner<?php echo esc_attr($border_style_bottom); ?>">
                                    <div class="thumb">
                                        <img src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($img_alt); ?>">
                                        <?php if(!empty($settings['thumb_date'])) : ?>
                                            <div class="date text-center">
                                                <?php echo get_the_date('j, M Y'); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="details">
                                        <ul class="author-meta">
                                            <li class="author pl-0">
                                                <i class="icomoon icomoon-user"></i>
                                                <?php panthar()->posted_by(); ?>
                                            </li>
                                            <?php if(!empty($settings['details_date'])) : ?>
                                                <li class="date"> 
                                                    <span class="mr-2"><?php echo esc_html__('|', 'panthar-core') ?></span>
                                                    <i class="fa fa-calendar"></i>
                                                    <?php panthar()->posted_on(); ?>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                        <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <?php if(!empty($settings['read_more'])) : ?>
                                            <div class="btn-wrap">
                                                <a href="<?php the_permalink(); ?>" class="read-btn"><?php echo esc_html($settings['read-btn']); ?> <span></span></a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php }else { ?>
                            <div class="<?php echo esc_attr($settings['blog_grid']); ?> col-md-6">
                                <div class="single-blog-item-inner single-blog-item-inner-2 <?php echo esc_attr($border_style_bottom); ?>">
                                    <div class="thumb">
                                        <img src="<?php echo esc_url($img_url); ?>" alt="<?php echo esc_attr($img_alt); ?>">
                                        <?php if(!empty($settings['thumb_date'])) : ?>
                                            <div class="date text-center">
                                                <?php echo get_the_date('j, M Y'); ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="details">
                                        <?php
                                            // Get the IDs of child categories if any
                                            $categories = get_the_category();
                                            foreach( $categories as $category ) {
                                                If ( $category->parent > 0 ) { 
                                                    $child_cat_ID[] =  $category->term_id; 
                                                }
                                            } 

                                            // If there are no child categories then display categories
                                            if (empty($child_cat_ID)) {
                                                echo get_the_category_list(' , ', '');

                                            // display child categories only
                                            } else {
                                                $child_cat_IDs = implode(', ', $child_cat_ID);
                                                echo '<div class="post-categories">';
                                                wp_list_categories(array(
                                                    'separator' => ' ',
                                                    'style' => '',
                                                    'include' => $child_cat_IDs
                                                ));
                                                echo '</div>';
                                            }
                                        ?>

                                        <h4 class="title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <ul class="author-meta mt-3">
                                            <li class="author pl-0">
                                                <i class="icomoon icomoon-user"></i>
                                                <?php panthar()->posted_by(); ?>
                                            </li>
                                            <?php if(!empty($settings['details_date'])) : ?>
                                                <li class="date"> 
                                                    <span class="mr-2"><?php echo esc_html__('|', 'panthar-core') ?></span>
                                                    <i class="fa fa-calendar"></i>
                                                    <?php panthar()->posted_on(); ?>
                                                </li>
                                            <?php endif; ?>
                                        </ul>
                                        <?php if(!empty($settings['read_more'])) : ?>
                                            <div class="btn-wrap">
                                                <a href="<?php the_permalink(); ?>" class="read-btn"><?php echo esc_html($settings['read-btn']); ?> <span></span></a>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php }
                    ?>
                <?php
                endwhile;
                wp_reset_query();
                ?>
                <?php if (!$pagination) { ?>
                    <div class="col-lg-12">
                        <div class="blog-pagination text-<?php echo esc_attr($pagination_alignment) ?> margin-top-20">
                            
                                <?PHP Panthar()->post_pagination($post_data); ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type(new Panthar_Blog_Grid_LIst_Two_Widget());