<?php
/**
 * Elementor Widget
 * @package Panthar
 * @since 1.0.0
 */

namespace Elementor;
class Panthar_Banner_Widget extends Widget_Base
{

    /**
     * Get widget name.
     *
     * Retrieve Elementor widget name.
     *
     * @return string Widget name.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_name()
    {
        return 'panthar-banner-widget';
    }

    /**
     * Get widget title.
     *
     * Retrieve Elementor widget title.
     *
     * @return string Widget title.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_title()
    {
        return esc_html__('Banner', 'panthar-core');
    }

    /**
     * Get widget icon.
     *
     * Retrieve Elementor widget icon.
     *
     * @return string Widget icon.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_icon()
    {
        return 'eicon-archive-title';
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the Elementor widget belongs to.
     *
     * @return array Widget categories.
     * @since 1.0.0
     * @access public
     *
     */
    public function get_categories()
    {
        return ['panthar_widgets'];
    }

    /**
     * Register Elementor widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('Section Contents', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        //hero area option field
        $this->add_control(
            'hero_image_status',
            [
                'label' => esc_html__('Hero Image Status', 'panthar-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'show',
                'options' => [
                    'show' => esc_html__('Show', 'panthar-core'),
                    'hide' => esc_html__('Hide', 'panthar-core'),
                ],
            ]
        );
        $this->add_control(
            'hero_image_position',
            [
                'label' => esc_html__('Hero Image Position', 'panthar-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'right',
                'options' => [
                    'left' => esc_html__('Left', 'panthar-core'),
                    'right' => esc_html__('Right', 'panthar-core'),
                ],
            ]
        );
        $this->add_control(
            'banner_content_alignment',
            [
                'label' => esc_html__('Banner Content Alignment', 'panthar-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'justify-content-left',
                'options' => [
                    'justify-content-left' => esc_html__('Left', 'panthar-core'),
                    'justify-content-center' => esc_html__('Center', 'panthar-core'),
                    'justify-content-end' => esc_html__('Right', 'panthar-core'),
                ],
                'condition' => [
                    'hero_image_status' => 'hide',
                ]
            ]
        );

        //banner field start
        $this->add_control(
            'hero_image', [
                'label' => esc_html__('Background Image', 'panthar-core'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'show_label' => false,
                'description' => esc_html__('upload background image', 'panthar-core'),
            ]
        );
        $this->add_control(
            'subtitle', [
                'label' => esc_html__('Sub Title', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Panthar', 'panthar-core'),
                'description' => esc_html__('enter description', 'panthar-core'),
            ]
        );
        $this->add_control(
            'title', [
                'label' => esc_html__('Title', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Book a private jet instantly', 'panthar-core'),
                'description' => esc_html__('enter title', 'panthar-core'),
            ]
        );
        $this->add_control(
            'description', [
                'label' => esc_html__('Description', 'panthar-core'),
                'type' => Controls_Manager::TEXTAREA,
                'default' => esc_html__('Curly Airline proudly raises the bar and exceeds the standard for luxury and corporate private jet charter services. We pride ourselves on offering a professional service.', 'panthar-core'),
                'description' => esc_html__('enter description', 'panthar-core'),
            ]
        );
        $this->add_control(
            'btn_text', [
                'label' => esc_html__('Button Text', 'panthar-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Make Your Trip', 'panthar-core'),
                'description' => esc_html__('enter button text', 'panthar-core'),
            ]
        );
        $this->add_control(
            'btn_link', [
                'label' => esc_html__('Button URL', 'panthar-core'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#'
                ],
                'description' => esc_html__('enter button url', 'panthar-core'),
                'condition' => ['btn_status' => 'yes'],
            ]
        );
        $this->add_control(
            'info_btn_text', [
                'label' => esc_html__('Button Text', 'panthar-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Request Quote', 'panthar-core'),
                'description' => esc_html__('enter button text', 'panthar-core'),
            ]
        );
        $this->add_control(
            'btn_link-02', [
                'label' => esc_html__('Button URL', 'panthar-core'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#'
                ],
                'description' => esc_html__('enter button url', 'panthar-core'),
            ]
        );


        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__( 'Alignment', 'elementor' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'elementor' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'elementor' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'elementor' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'elementor' ),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();


        //animate image field start
        $this->start_controls_section(
            'animate_image_section',
            [
                'label' => esc_html__('Animate Image Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'animate_icon',
            [
                'label' => esc_html__('Animation Icon', 'panthar-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'panthar-core'),
                'default' => [
                    'value' => 'fas fa-plus',
                    'library' => 'solid',
                ]
            ]
        );
        $this->add_control(
            'animate_icon_02',
            [
                'label' => esc_html__('Animation Icon Two', 'panthar-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'panthar-core'),
                'default' => [
                    'value' => 'fas fa-plus',
                    'library' => 'solid',
                ]
            ]
        );
        $this->add_control(
            'animate_icon_03',
            [
                'label' => esc_html__('Animation Icon Three', 'panthar-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'panthar-core'),
                'default' => [
                    'value' => 'fas fa-plus',
                    'library' => 'solid',
                ]
            ]
        );
        $this->end_controls_section();


        //social icon field start
        $this->start_controls_section(
            'social_icon_section',
            [
                'label' => esc_html__('Social Icon Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $repeater = new Repeater();

        $repeater->add_control(
            'list_icon',
            [
                'label' => esc_html__('Icon', 'panthar-core'),
                'type' => Controls_Manager::ICONS,
                'description' => esc_html__('select Icon.', 'panthar-core'),
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ]
            ]
        );

        $repeater->add_control(
            'list_icon_link',
            [
                'label' => __('Link', 'panthar-core'),
                'type' => Controls_Manager::URL,
                'placeholder' => __('https://example.com', 'panthar-core'),
                'show_external' => true
            ]
        );
        $this->add_control('social_icon_list', [
            'label' => esc_html__('Social Icon List', 'panthar-core'),
            'type' => Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls()
        ]);
        $this->end_controls_section();


        $this->start_controls_section(
            'css_styles',
            [
                'label' => esc_html__('Styling Settings', 'panthar-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control('slider_title_color', [
            'label' => esc_html__('Slider Title Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .title" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('slider_subtitle_bg_color', [
            'label' => esc_html__('Slider Sub Title Background Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-inner .subtitle" => "background-color: {{VALUE}}"
            ]
        ]);
        $this->add_control('slider_subtitle_color', [
            'label' => esc_html__('Slider Sub Title Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-inner .subtitle" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_responsive_control('padding', [
            'label' => esc_html__('Padding', 'panthar-core'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em'],
            'allowed_dimensions' => ['top', 'bottom'],
            'selectors' => [
                '{{WRAPPER}} .header-area' => 'padding-top: {{TOP}}{{UNIT}};padding-bottom: {{BOTTOM}}{{UNIT}};'
            ],
            'description' => esc_html__('set padding for header area ', 'panthar-core')
        ]);
        $this->add_control('overlay_color', [
            'label' => esc_html__('Overlay Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .header-area.header-bg::before' => 'background-color:{{VALUE}};'
            ],
        ]);

        $this->end_controls_section();

        /* button styling */
        $this->start_controls_section('header_button_section', [
            'label' => esc_html__('Button Settings', 'panthar-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);

        $this->start_controls_tabs('button_styling');
        $this->start_controls_tab('normal_style', [
            'label' => esc_html__('Button Normal', "panthar-core")
        ]);
        $this->add_control('button_normal_color', [
            'label' => esc_html__('Button Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('divider_01', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'button_background',
            'label' => esc_html__('Button Background ', 'panthar-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn"
        ]);
        $this->add_control('divider_02', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'header_button_border',
            'label' => esc_html__('Border', 'panthar-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn"
        ]);
        $this->add_control('divider_060', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_control('info_button_normal_color', [
            'label' => esc_html__('Info Button Text Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-buttom-content p" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('info_number_button_normal_color', [
            'label' => esc_html__('Info Button Number Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-buttom-content span" => "color: {{VALUE}}"
            ]
        ]);
        $this->end_controls_tab();

        $this->start_controls_tab('hover_style', [
            'label' => esc_html__('Button Hover', "panthar-core")
        ]);
        $this->add_control('button_hover_normal_color', [
            'label' => esc_html__('Button Color', 'panthar-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn:hover" => "color: {{VALUE}}"
            ]
        ]);
        $this->add_control('divider_03', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Background::get_type(), [
            'name' => 'button_hover_background',
            'label' => esc_html__('Button Background ', 'panthar-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn:hover"
        ]);
        $this->add_control('divider_04', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_group_control(Group_Control_Border::get_type(), [
            'name' => 'header_hover_button_border',
            'label' => esc_html__('Border', 'panthar-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn:hover"
        ]);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control('divider_05', [
            'type' => Controls_Manager::DIVIDER
        ]);
        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('Border Radius', 'panthar-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
        /* button styling end */

        /* typography settings start */
        $this->start_controls_section('typography_settings', [
            'label' => esc_html__('Typography Settings', 'panthar-core'),
            'tab' => Controls_Manager::TAB_STYLE
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'title_typography',
            'label' => esc_html__('Title Typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .header-area .title"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'subtitle_typography',
            'label' => esc_html__('Sub Title Typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .header-area .header-inner .subtitle"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'button_typography',
            'label' => esc_html__('Button Typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .header-area .header-bottom .btn-wrapper .boxed-btn"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'info_button_typography',
            'label' => esc_html__('Info Text Typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .header-area .header-buttom-content p"
        ]);
        $this->add_group_control(Group_Control_Typography::get_type(), [
            'name' => 'info_number_button_typography',
            'label' => esc_html__('Info number Typography', 'panthar-core'),
            'selector' => "{{WRAPPER}} .header-area .header-buttom-content span"
        ]);
        $this->end_controls_section();
        /* typography settings end */

    }

    /**
     * Render Elementor widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        //hero image variable
        $hero_image = $this->get_settings('hero_image');
        $infobox_image_url = Group_Control_Image_Size::get_attachment_image_src($hero_image['id'], 'thumbnail', $settings);
        if (empty($hero_image_url)){
            $hero_image_url = $hero_image['url'];
        }

        //hero image position
        $hero_image_position = $settings['hero_image_position'];
        if($hero_image_position == "left") :
            $hero_image_position_status_image = 'order-1';
            $hero_image_position_status_content = 'order-12';
        endif;



        ?>
        <div class="hero-area-wrapper">
            <div class="header-area header-bg">
                <div class="animate-icon">
                    <?php
                    Icons_Manager::render_icon($settings['animate_icon'], ['aria-hidden' => 'true']);
                    ?>
                </div>
                <div class="animate-icon-02">
                    <?php
                    Icons_Manager::render_icon($settings['animate_icon_02'], ['aria-hidden' => 'true']);
                    ?>
                </div>
                <div class="animate-icon-03">
                    <?php
                    Icons_Manager::render_icon($settings['animate_icon_03'], ['aria-hidden' => 'true']);
                    ?>
                </div>
                <div class="container nav-container">
                    <ul class="social-link style-01">
                        <?php
                        foreach ($settings['social_icon_list'] as $item) :
                            ?>
                            <li>
                                <a <?php echo panthar_core()->render_elementor_link_attributes($item['list_icon_link']); ?>>
                                    <?php
                                    Icons_Manager::render_icon($item['list_icon'], ['aria-hidden' => 'true']);
                                    ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                    <div class="row <?php echo $settings['banner_content_alignment']; ?>">
                        <div class="col-lg-5 <?php echo $hero_image_position_status_content; ?>">
                            <div class="header-inner">
                                <?php if (!empty($settings['subtitle'])): ?>
                                    <span class="subtitle">
                                        <?php
                                        $subtitle = str_replace(['{c}', '{/c}'], ['<span>', '</span>'], $settings['subtitle']);
                                        print wp_kses($subtitle, panthar_core()->kses_allowed_html('all'));
                                        ?>
                                    </span>
                                <?php endif; ?>
                                <h2 class="title"><?php echo esc_html($settings['title']) ?></h2>
                                <?php if (!empty($settings['description'])): ?>
                                    <p>
                                        <?php echo esc_html($settings['description']) ?>
                                    </p>
                                <?php endif; ?>
                                <?php if(!empty($settings['btn_text'] || $settings['info_btn_text'])) : ?>
                                    <div class="header-bottom d-inline-block">
                                        <div class="btn-wrapper desktop-left">
                                            <?php if(!empty($settings['btn_text'])) : ?>
                                                <a href="<?php echo esc_url($settings['btn_link']['url']) ?>"
                                                   class="boxed-btn blank"><i class="fas fa-chevron-right mr-2"></i><?php echo esc_html($settings['btn_text']) ?></a>
                                            <?php endif; ?>
                                            <?php if(!empty($settings['info_btn_text'])) : ?>
                                                <a href="<?php echo esc_url($settings['btn_link_02']['url']) ?>"
                                                   class="blank-btn"><?php echo esc_html($settings['info_btn_text']) ?><i class="icomoon-Group-2361 ml-2"></i></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if($settings['hero_image_status'] == 'show'): ?>
                            <div class="col-lg-6 <?php $hero_image_position_status_image; ?>">
                                <div class="thumb">
                                    <img src="<?php echo esc_url($hero_image_url) ?>" alt="<?php echo esc_attr('thumb', 'panthar-core') ?>">
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
Plugin::instance()->widgets_manager->register_widget_type(new Panthar_Banner_Widget());