<?php
/**
 *  Panthar Social Share widget
 * @package Panthar
 * @since 1.0.0
 */
if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {

    //
    // Create a About Widget
    //
    CSF::createWidget('panthar_service_doc_widget', array(
        'title' => esc_html__('Panthar: Service Document', 'panthar-master'),
        'classname' => 'panthar-service-doct',
        'description' => esc_html__('Display Service Document widget', 'panthar-master'),
        'fields' => array(
            array(
                'id' => 'heading',
                'type' => 'text',
                'title' => esc_html__('Enter Your Header Title', 'panthar-master'),
                'default' => esc_html__('Download', 'panthar-master')
            ),
            array(
                'id' => 'panthar-service-doc-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Document Icon', 'panthar-master'),
                'fields' => array(
                    array(
                        'id'          => 'panthar-style-select',
                        'type'        => 'select',
                        'title' => esc_html__('Icon', 'panthar-master'),
                        'default' => '',
                        'options'     => array(
                            ''  => 'Yellow Color',
                            'style-01'  => 'Blue Color',
                        ),
                    ),
                    array(
                        'id' => 'panthar-doc-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Icon', 'panthar-master'),
                        'default' => 'far fa-file-pdf'
                    ),
                    array(
                        'id' => 'panthar-doc-text',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Text', 'panthar-master'),
                        'default' => 'Full Documents'
                    ),
                    array(
                        'id' => 'panthar-doc-url',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Ulr', 'panthar-master'),
                        'default' => '#'
                    ),
                ),
            ),
        )
    ));

    //
    // Front-end display of widget example 1
    // Attention: This function named considering above widget base id.
    //
    if (!function_exists('panthar_service_doc_widget')) {
        function panthar_service_doc_widget($args, $instance)
        {

            echo $args['before_widget'];

            // var_dump( $args ); // Widget arguments
            // var_dump( $instance ); // Saved values from database

            $socialIcon = is_array($instance['panthar-service-doc-repeater']) && !empty($instance['panthar-service-doc-repeater']) ? $instance['panthar-service-doc-repeater'] : [];
            $heading_title = $instance['heading'] ?? '';

            ?>
            <div class="service-doc-widget">
                <h4 class="widget-headline"><?php echo $heading_title; ?></h4>
                <ul class="doc-link">
                    <?php
                    foreach ($socialIcon as $icon) {
                        printf('<li><a class="%4$s" href="%2$s"><i class="%1$s"></i>%3$s</a></li>', esc_html($icon['panthar-doc-icon']), esc_url($icon['panthar-doc-url']),esc_html($icon['panthar-doc-text']),esc_html($icon['panthar-style-select']));
                    };
                    ?>
                </ul>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>