<?php
/**
 * Theme About Me Widget
 * @package Panthar
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}
// Control core classes for avoid errors
if (class_exists('CSF')) {


    // Create a About Widget
    CSF::createWidget('panthar_about_me_widget', array(
        'title' => esc_html__('Panthar: About Me', 'panthar-core'),
        'classname' => 'panthar-widget-about-me',
        'description' => esc_html__('Display about Me widget', 'panthar-core'),
        'fields' => array(
            array(
                'id' => 'about_me_title',
                'type' => 'textarea',
                'title' => esc_html__('Title', 'Panthar-core'),
                'default' => esc_html__('about us', 'panthar-core')
            ),
            array(
                'id' => 'description',
                'type' => 'textarea',
                'title' => esc_html__('Description', 'Panthar-core'),
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore.', 'panthar-core')
            ),

            array(
                'id' => 'panthar-footer-social-icon-repeater',
                'type' => 'repeater',
                'title' => esc_html__('Social', 'panthar-core'),
                'fields' => array(

                    array(
                        'id' => 'panthar-footer-social-icon',
                        'type' => 'icon',
                        'title' => esc_html__('Social Name', 'panthar-core'),
                        'default' => 'facebook'
                    ),
                    array(
                        'id' => 'panthar-footer-social-url',
                        'type' => 'text',
                        'title' => esc_html__('Enter Your Url', 'panthar-core'),
                        'default' => esc_html__('#', 'panthar-core')
                    ),

                ),
            ),
        )
    ));


    if (!function_exists('panthar_about_me_widget')) {
        function panthar_about_me_widget($args, $instance)
        {

            echo $args['before_widget'];

            // var_dump( $args ); // Widget arguments
            // var_dump( $instance ); // Saved values from database

            $about_me_title = $instance['about_me_title'] ?? '';
            $paragraph = $instance['description'] ?? '';
            $socialIcon = is_array($instance['panthar-footer-social-icon-repeater']) && !empty($instance['panthar-footer-social-icon-repeater']) ? $instance['panthar-footer-social-icon-repeater'] : [];


            ?>
            <div class="footer-widget widget">
                <div class="about_me_widget style-01">
                    <h4 class="widget-title footer-title"><?php echo $about_me_title; ?></h4>
                    <p> <?php echo $paragraph; ?></p>
                    <ul class="contact_info_list">
                        <?php
                        foreach ($socialIcon as $icon) {
                            echo '<li class="single-info-item-list">
                            <div class="icon">
                                <a href="'.$icon['panthar-footer-social-url'].'">
                                    <i class="' . $icon['panthar-footer-social-icon'] . '"></i>
                                </a>
                            </div>
                        </li>';
                        };
                        ?>
                    </ul>
                </div>
            </div>

            <?php

            echo $args['after_widget'];

        }
    }

}

?>