<?php
/**
 * Theme Core Init
 * @package panthar
 * @since 1.0.0
 */

if (!defined("ABSPATH")) {
	exit(); //exit if access directly
}

if (!class_exists('Panthar_Core_Init')) {

	class Panthar_Core_Init
	{
	   /**
        * $instance
        * @since 1.0.0
        */
		protected static $instance;

		public function __construct()
		{
			//Load plugin assets
			add_action('wp_enqueue_scripts', array($this, 'plugin_assets'));
			//Load plugin admin assets
			add_action('admin_enqueue_scripts', array($this, 'admin_assets'));
			//load plugin text domain
			add_action('init', array($this, 'load_textdomain'));
			//add custom icon to codester framework
			add_filter('csf_field_icon_add_icons', array($this, 'csf_custom_icon'));
			//load plugin dependency files()
            add_action('plugin_loaded', array($this, 'load_plugin_dependency_files'));
		}

	   /**
        * getInstance()
        * @since 1.0.0
        */
		public static function getInstance()
		{
			if (null == self::$instance) {
				self::$instance = new self();
			}
			return self::$instance;
		}

		/**
		 * Load Plugin Text domain
		 * @since 1.0.0
		 */
		public function load_textdomain()
		{
			load_plugin_textdomain('panthar-core', false, PANTHAR_CORE_ROOT_PATH . '/languages');
		}

		/**
		 * Load plugin dependency files()
		 * @since 1.0.0
		 */
		public function load_plugin_dependency_files()
		{
			$includes_files = array(
				array(
					'file-name' => 'codestar-framework',
					'folder-name' => PANTHAR_CORE_LIB . '/codestar-framework'
				),
				array(
					'file-name' => 'theme-menu-page',
					'folder-name' => PANTHAR_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-custom-post-type',
					'folder-name' => PANTHAR_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-post-column-customize',
					'folder-name' => PANTHAR_CORE_ADMIN
				),
				array(
					'file-name' => 'theme-panthar-core-excerpt',
					'folder-name' => PANTHAR_CORE_INC
				),
				array(
					'file-name' => 'csf-taxonomy',
					'folder-name' => PANTHAR_CORE_INC
				),
				array(
					'file-name' => 'theme-core-shortcodes',
					'folder-name' => PANTHAR_CORE_INC
				),
				array(
					'file-name' => 'elementor-widget-init',
					'folder-name' => PANTHAR_CORE_ELEMENTOR
				),
				array(
                    'file-name' => 'theme-service-doc-widget',
                    'folder-name' => PANTHAR_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-social-share-widget',
                    'folder-name' => PANTHAR_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-about-me-widget',
                    'folder-name' => PANTHAR_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-about-us-widget',
                    'folder-name' => PANTHAR_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-search-widget',
                    'folder-name' => PANTHAR_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-tags-menu',
                    'folder-name' => PANTHAR_CORE_WP_WIDGETS
                ),
				array(
					'file-name' => 'theme-recent-post-widget',
					'folder-name' => PANTHAR_CORE_WP_WIDGETS
				),
				array(
					'file-name' => 'theme-contact-info-widget',
					'folder-name' => PANTHAR_CORE_WP_WIDGETS
				),
                array(
                    'file-name' => 'theme-service-category-widget',
                    'folder-name' => PANTHAR_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-request-form-widget',
                    'folder-name' => PANTHAR_CORE_WP_WIDGETS
                ),
                array(
                    'file-name' => 'theme-post-category-widget',
                    'folder-name' => PANTHAR_CORE_WP_WIDGETS
                ),
				array(
					'file-name' => 'theme-demo-data-import',
					'folder-name' => PANTHAR_CORE_DEMO_IMPORT
				),
			);

            if (defined('ELEMENTOR_VERSION')) {
                $includes_files[] = array(
                    'file-name' => 'theme-elementor-icon-manager',
                    'folder-name' => PANTHAR_CORE_INC
                );
            }
			if (is_array($includes_files) && !empty($includes_files)) {
				foreach ($includes_files as $file) {
					if (file_exists($file['folder-name'] . '/' . $file['file-name'] . '.php')) {
						require_once $file['folder-name'] . '/' . $file['file-name'] . '.php';
					}
				}
			}
		}

		/**
		 * Admin assets
		 * @since 1.0.0
		 */
		public function plugin_assets()
		{
			self::load_plugin_css_files();
			self::load_plugin_js_files();
		}

		/**
		 * Load plugin css files()
		 * @since 1.0.0
		 */
		public function load_plugin_css_files()
		{
			$plugin_version = PANTHAR_CORE_VERSION;
			$rtl = is_rtl() ? 'rtl' : 'ltr';
			$all_css_files = array(
				array(
					'handle' => 'icomoon',
					'src' => PANTHAR_CORE_CSS . '/icomoon.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
				array(
					'handle' => 'owl-carousel',
					'src' => PANTHAR_CORE_CSS . '/owl.carousel.min.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
                array(
                    'handle' => 'slick',
                    'src' => PANTHAR_CORE_CSS . '/slick.css',
                    'deps' => array(),
                    'ver' => $plugin_version,
                    'media' => 'all'
                ),
				array(
					'handle' => 'fontawesome',
					'src' => PANTHAR_CORE_CSS . '/font-awesome.min.css',
					'deps' => array(),
					'ver' => '5.12.0',
					'media' => 'all'
				),
				array(
					'handle' => 'panthar-core-main-style',
					'src' => PANTHAR_CORE_CSS . '/main-style-'.$rtl.'.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				)
			);
			
			if (!panthar_core()->is_panthar_active()) {
				$all_css_files[] = array(
					'handle' => 'animate',
					'src' => PANTHAR_CORE_CSS . '/animate.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'bootstrap',
					'src' => PANTHAR_CORE_CSS . '/bootstrap.min.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'magnific-popup',
					'src' => PANTHAR_CORE_CSS . '/magnific-popup.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'panthar-main-style',
					'src' => PANTHAR_CORE_CSS . '/theme-style.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
				$all_css_files[] = array(
					'handle' => 'panthar-responsive',
					'src' => PANTHAR_CORE_CSS . '/theme-responsive.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				);
			}
			$all_css_files = apply_filters('panthar_core_css', $all_css_files);

			if (is_array($all_css_files) && !empty($all_css_files)) {
				foreach ($all_css_files as $css) {
					call_user_func_array('wp_enqueue_style', $css);
				}
			}
		}

		/**
		 * Load plugin js
		 * @since 1.0.0
		 */
		public function load_plugin_js_files()
		{
			$plugin_version = PANTHAR_CORE_VERSION;
			$all_js_files = array(
                array(
                    'handle' => 'wow',
                    'src' => PANTHAR_CORE_JS . '/wow.min.js',
                    'deps' => array('jquery'),
                    'ver' => $plugin_version,
                    'in_footer' => true
                ),
				array(
					'handle' => 'waypoints',
					'src' => PANTHAR_CORE_JS . '/waypoints.min.js',
					'deps' => array('jquery'),
					'ver' => $plugin_version,
					'in_footer' => true
				),
				array(
					'handle' => 'pie-chart',
					'src' => PANTHAR_CORE_JS . '/pie-chart.js',
					'deps' => array('jquery'),
					'ver' => $plugin_version,
					'in_footer' => true
				),
				array(
					'handle' => 'counterup',
					'src' => PANTHAR_CORE_JS . '/jquery.counterup.min.js',
					'deps' => array('jquery'),
					'ver' => $plugin_version,
					'in_footer' => true
				),
                array(
                    'handle' => 'rProgressbar',
                    'src' => PANTHAR_CORE_JS . '/jQuery.rProgressbar.min.js',
                    'deps' => array('jquery'),
                    'ver' => $plugin_version,
                    'in_footer' => true
                ),
				array(
					'handle' => 'owl-carousel',
					'src' => PANTHAR_CORE_JS . '/owl.carousel.min.js',
					'deps' => array('jquery'),
					'ver' => $plugin_version,
					'in_footer' => true
				),
                array(
                    'handle' => 'slick',
                    'src' => PANTHAR_CORE_JS . '/slick.min.js',
                    'deps' => array('jquery'),
                    'ver' => $plugin_version,
                    'in_footer' => true
                ),
				array(
					'handle' => 'panthar-core-main-script',
					'src' => PANTHAR_CORE_JS . '/main.js',
					'deps' => array('jquery'),
					'ver' => $plugin_version,
					'in_footer' => true
				),
			);

			if (!panthar_core()->is_panthar_active()) {
				$all_js_files[] = array(
					'handle' => 'popper',
					'src' => PANTHAR_CORE_JS . '/popper.min.js',
					'deps' => array('jquery'),
					'ver' => $plugin_version,
					'in_footer' => true
				);
				$all_js_files[] = array(
					'handle' => 'bootstrap',
					'src' => PANTHAR_CORE_JS . '/bootstrap.min.js',
					'deps' => array('jquery'),
					'ver' => $plugin_version,
					'in_footer' => true
				);
				$all_js_files[] = array(
					'handle' => 'magnific-popup',
					'src' => PANTHAR_CORE_JS . '/jquery.magnific-popup.js',
					'deps' => array('jquery'),
					'ver' => $plugin_version,
					'in_footer' => true
				);
			}

			$all_js_files = apply_filters('panthar_core_frontend_script_enqueue', $all_js_files);
			if (is_array($all_js_files) && !empty($all_js_files)) {
				foreach ($all_js_files as $js) {
					call_user_func_array('wp_enqueue_script', $js);
				}
			}
		}

		/**
		 * Admin assets
		 * @since 1.0.0
		 */
		public function admin_assets()
		{
			self::load_admin_css_files();
			self::load_admin_js_files();
		}

		/**
		 * Load plugin admin css files()
		 * @since 1.0.0
		 */
		public function load_admin_css_files()
		{
			$plugin_version = PANTHAR_CORE_VERSION;
			$all_css_files = array(
				array(
					'handle' => 'panthar-core-admin-style',
					'src' => PANTHAR_CORE_ADMIN_ASSETS . '/css/admin.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
				array(
					'handle' => 'icomoon',
					'src' => PANTHAR_CORE_CSS . '/icomoon.css',
					'deps' => array(),
					'ver' => $plugin_version,
					'media' => 'all'
				),
			);

			$all_css_files = apply_filters('panthar_admin_css', $all_css_files);
			if (is_array($all_css_files) && !empty($all_css_files)) {
				foreach ($all_css_files as $css) {
					call_user_func_array('wp_enqueue_style', $css);
				}
			}
		}

		/**
		 * Load plugin admin js
		 * @since 1.0.0
		 */
		public function load_admin_js_files()
		{
			$plugin_version = PANTHAR_CORE_VERSION;
			$all_js_files = array(
				array(
					'handle' => 'panthar-core-widget',
					'src' => PANTHAR_CORE_ADMIN_ASSETS . '/js/widget.js',
					'deps' => array('jquery'),
					'ver' => $plugin_version,
					'in_footer' => true
				),
			);

			$all_js_files = apply_filters('panthar_admin_js', $all_js_files);
			if (is_array($all_js_files) && !empty($all_js_files)) {
				foreach ($all_js_files as $js) {
					call_user_func_array('wp_enqueue_script', $js);
				}
			}
		}

		/**
		 * Add Custom Icon To Codester Framework
		 * @since 1.0.0
		 */
		public function csf_custom_icon($icons)
		{
			//adding new icon
			$icons[]  = array(
				'title' => esc_html__('Icomoon', 'panthar-core'),
				'icons' => array(
					'icomoon-accordion-minus',
					'icomoon-accordion-plus',
					'icomoon-award-1',
					'icomoon-award-2',
					'icomoon-award-3',
					'icomoon-award-4',
					'icomoon-award-5',
					'icomoon-award-6',
					'icomoon-award--7',
					'icomoon-bag',
					'icomoon-book',
					'icomoon-book-2',
					'icomoon-book-3',
					'icomoon-building',
					'icomoon-bullet',
					'icomoon-bullet-left',
					'icomoon-calculator',
					'icomoon-chat-quote',
					'icomoon-dimond',
					'icomoon-dot-menu',
					'icomoon-down-arrow',
					'icomoon-flag',
					'icomoon-hand-shake',
					'icomoon-hand-shake-2',
					'icomoon-heart',
					'icomoon-hero-1',
					'icomoon-hero-2',
					'icomoon-left-arrow',
					'icomoon-mail',
					'icomoon-mail-2',
					'icomoon-map-marker',
					'icomoon-mapmarker-2',
					'icomoon-map-marker-3',
					'icomoon-menu-dot-2',
					'icomoon-old-man',
					'icomoon-phone',
					'icomoon-phone-2',
					'icomoon-phone-call',
					'icomoon-play-btn',
					'icomoon-plus-sign',
					'icomoon-policeman',
					'icomoon-right-arrow',
					'icomoon-search',
					'icomoon-share',
					'icomoon-team',
					'icomoon-top-right-arrow',
					'icomoon-trophy',
					'icomoon-user',
					'icomoon-user-2'
				)
			);

			$icons = array_reverse($icons);

			return $icons;
		}
	} //end class
	if (class_exists('Panthar_Core_Init')) {
		Panthar_Core_Init::getInstance();
	}
}
