<?php
/**
 * Theme Custom Post Type(CPTs)
 * @package Panthar
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
    exit(); //exit if access directly
}

if (!class_exists('Panthar_Custom_Post_Type')) {
    class Panthar_Custom_Post_Type
    {

        //$instance variable
        private static $instance;

        public function __construct()
        {
            //register post type
            add_action('init', array($this, 'register_custom_post_type'));
        }

        /**
         * get Instance
         * @since  2.0.0
         */
        public static function getInstance()
        {
            if (null == self::$instance) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        /**
         * Register Custom Post Type
         * @since  2.0.0
         */
        public function register_custom_post_type()
        {
            if (!defined('ELEMENTOR_VERSION')) {
                return;
            }
            $all_post_type = array(
                [
                    'post_type' => 'service',
                    'args' => array(
                        'label' => esc_html__('Service', 'panthar-core'),
                        'description' => esc_html__('Service', 'panthar-core'),
                        'labels' => array(
                            'name' => esc_html_x('Service', 'Post Type General Name', 'panthar-core'),
                            'singular_name' => esc_html_x('Service', 'Post Type Singular Name', 'panthar-core'),
                            'menu_name' => esc_html__('Service', 'panthar-core'),
                            'all_items' => esc_html__('Services', 'panthar-core'),
                            'view_item' => esc_html__('View Service', 'panthar-core'),
                            'add_new_item' => esc_html__('Add New Service', 'panthar-core'),
                            'add_new' => esc_html__('Add New Service', 'panthar-core'),
                            'edit_item' => esc_html__('Edit Service', 'panthar-core'),
                            'update_item' => esc_html__('Update Service', 'panthar-core'),
                            'search_items' => esc_html__('Search Service', 'panthar-core'),
                            'not_found' => esc_html__('Not Found', 'panthar-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'panthar-core'),
                            'featured_image' => esc_html__('Service Image', 'panthar-core'),
                            'remove_featured_image' => esc_html__('Remove Service Image', 'panthar-core'),
                            'set_featured_image' => esc_html__('Set Service Image', 'panthar-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'taxonomies' => array( 'post_tag'), // this is IMPORTANT
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => 'panthar_theme_options',
                        "rewrite" => array('slug' => 'all-services', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ],
                [
                    'post_type' => 'case-study',
                    'args' => array(
                        'label' => esc_html__('Case Study', 'panthar-core'),
                        'description' => esc_html__('Case Study', 'panthar-core'),
                        'labels' => array(
                            'name' => esc_html_x('Case Study', 'Post Type General Name', 'panthar-core'),
                            'singular_name' => esc_html_x('Case Study', 'Post Type Singular Name', 'panthar-core'),
                            'menu_name' => esc_html__('Case Study', 'panthar-core'),
                            'all_items' => esc_html__('Case Study', 'panthar-core'),
                            'view_item' => esc_html__('View Case Study', 'panthar-core'),
                            'add_new_item' => esc_html__('Add New Case Study', 'panthar-core'),
                            'add_new' => esc_html__('Add New Case Study', 'panthar-core'),
                            'edit_item' => esc_html__('Edit Case Study', 'panthar-core'),
                            'update_item' => esc_html__('Update Case Study', 'panthar-core'),
                            'search_items' => esc_html__('Search Case Study', 'panthar-core'),
                            'not_found' => esc_html__('Not Found', 'panthar-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'panthar-core'),
                            'featured_image' => esc_html__('Case Study Image', 'panthar-core'),
                            'remove_featured_image' => esc_html__('Remove Case Study Image', 'panthar-core'),
                            'set_featured_image' => esc_html__('Set Case Study Image', 'panthar-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => 'panthar_theme_options',
                        "rewrite" => array('slug' => 'all-case-study', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ],
                [
                    'post_type' => 'gallery',
                    'args' => array(
                        'label' => esc_html__('Gallery', 'panthar-core'),
                        'description' => esc_html__('Gallery', 'panthar-core'),
                        'labels' => array(
                            'name' => esc_html_x('Gallery', 'Post Type General Name', 'panthar-core'),
                            'singular_name' => esc_html_x('Gallery', 'Post Type Singular Name', 'panthar-core'),
                            'menu_name' => esc_html__('Gallery', 'panthar-core'),
                            'all_items' => esc_html__('Gallery', 'panthar-core'),
                            'view_item' => esc_html__('View Gallery', 'panthar-core'),
                            'add_new_item' => esc_html__('Add New Gallery', 'panthar-core'),
                            'add_new' => esc_html__('Add New Gallery', 'panthar-core'),
                            'edit_item' => esc_html__('Edit Gallery', 'panthar-core'),
                            'update_item' => esc_html__('Update Gallery', 'panthar-core'),
                            'search_items' => esc_html__('Search Gallery', 'panthar-core'),
                            'not_found' => esc_html__('Not Found', 'panthar-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'panthar-core'),
                            'featured_image' => esc_html__('Gallery Image', 'panthar-core'),
                            'remove_featured_image' => esc_html__('Remove Gallery Image', 'panthar-core'),
                            'set_featured_image' => esc_html__('Set Gallery Image', 'panthar-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => 'panthar_theme_options',
                        "rewrite" => array('slug' => 'all-gallery', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ],
                [
                    'post_type' => 'team',
                    'args' => array(
                        'label' => esc_html__('team', 'panthar-core'),
                        'description' => esc_html__('team', 'panthar-core'),
                        'labels' => array(
                            'name' => esc_html_x('Team', 'Post Type General Name', 'panthar-core'),
                            'singular_name' => esc_html_x('Team', 'Post Type Singular Name', 'panthar-core'),
                            'menu_name' => esc_html__('Teams', 'panthar-core'),
                            'all_items' => esc_html__('Teams', 'panthar-core'),
                            'view_item' => esc_html__('View Teams', 'panthar-core'),
                            'add_new_item' => esc_html__('Add New Team Member', 'panthar-core'),
                            'add_new' => esc_html__('Add New Team Member', 'panthar-core'),
                            'edit_item' => esc_html__('Edit Team', 'panthar-core'),
                            'update_item' => esc_html__('Update Team', 'panthar-core'),
                            'search_items' => esc_html__('Search Team', 'panthar-core'),
                            'not_found' => esc_html__('Not Found', 'panthar-core'),
                            'not_found_in_trash' => esc_html__('Not found in Trash', 'panthar-core'),
                            'featured_image' => esc_html__('Team Image', 'panthar-core'),
                            'remove_featured_image' => esc_html__('Remove Team Image', 'panthar-core'),
                            'set_featured_image' => esc_html__('Set Team Image', 'panthar-core'),
                        ),
                        'supports' => array('title', 'thumbnail', 'excerpt', 'editor', 'comments'),
                        'hierarchical' => false,
                        'public' => true,
                        "publicly_queryable" => true,
                        'show_ui' => true,
                        'show_in_menu' => 'panthar_theme_options',
                        "rewrite" => array('slug' => 'all-team', 'with_front' => true),
                        'can_export' => true,
                        'capability_type' => 'post',
                        "show_in_rest" => true,
                        'query_var' => true
                    )
                ]
            );

            if (!empty($all_post_type) && is_array($all_post_type)) {

                foreach ($all_post_type as $post_type) {
                    call_user_func_array('register_post_type', $post_type);
                }
            }


            /**
             * Custom Taxonomy Register
             * @since 1.0.0
            */

            $all_custom_taxonmy = array(
                array(
                    'taxonomy' => 'service-cat',
                    'object_type' => 'service',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Service Category", 'panthar-core'),
                            "singular_name" => esc_html__("Service Category", 'panthar-core'),
                            "menu_name" => esc_html__("Service Category", 'panthar-core'),
                            "all_items" => esc_html__("All Service Category", 'panthar-core'),
                            "add_new_item" => esc_html__("Add New Service Category", 'panthar-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'service-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),

                array(
                    'taxonomy' => 'case-study-cat',
                    'object_type' => 'case-study',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Case Study Category", 'panthar-core'),
                            "singular_name" => esc_html__("Case Study Category", 'panthar-core'),
                            "menu_name" => esc_html__("Case Study Category", 'panthar-core'),
                            "all_items" => esc_html__("All Case Study Category", 'panthar-core'),
                            "add_new_item" => esc_html__("Add New Case Study Category", 'panthar-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'case-study-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),
                array(
                    'taxonomy' => 'gallery-cat',
                    'object_type' => 'gallery',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Gallery Category", 'panthar-core'),
                            "singular_name" => esc_html__("Gallery Category", 'panthar-core'),
                            "menu_name" => esc_html__("Gallery Category", 'panthar-core'),
                            "all_items" => esc_html__("All Gallery Category", 'panthar-core'),
                            "add_new_item" => esc_html__("Add New Gallery Category", 'panthar-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'gallery-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                ),
                array(
                    'taxonomy' => 'team-cat',
                    'object_type' => 'team',
                    'args' => array(
                        "labels" => array(
                            "name" => esc_html__("Team Category", 'panthar-core'),
                            "singular_name" => esc_html__("Team Category", 'panthar-core'),
                            "menu_name" => esc_html__("Team Category", 'panthar-core'),
                            "all_items" => esc_html__("All Team Category", 'panthar-core'),
                            "add_new_item" => esc_html__("Add New Team Category", 'panthar-core')
                        ),
                        "public" => true,
                        "hierarchical" => true,
                        "show_ui" => true,
                        "show_in_menu" => true,
                        "show_in_nav_menus" => true,
                        "query_var" => true,
                        "rewrite" => array('slug' => 'team-cat', 'with_front' => true),
                        "show_admin_column" => true,
                        "show_in_rest" => true,
                        "show_in_quick_edit" => true,
                    )
                )
            );

            if (is_array($all_custom_taxonmy) && !empty($all_custom_taxonmy)) {
                foreach ($all_custom_taxonmy as $taxonomy) {
                    call_user_func_array('register_taxonomy', $taxonomy);
                }
            }

            flush_rewrite_rules();
        }

    }//end class

    if (class_exists('Panthar_Custom_Post_Type')) {
        Panthar_Custom_Post_Type::getInstance();
    }
}